function fd = importFinalDrive(dataFile)
arguments
    dataFile string = [];
end

if isempty(dataFile)
    [dataFile, path] = uigetfile({'*.xlsx;*.xls',...
        'Excel Spreadsheet (*.xlsx,*.xls)';
        '*.*',  'All Files (*.*)'}, ...
        'Select a File');
    dataFile = fullfile(path, dataFile);
end
[~, dataFileName] = fileparts(dataFile);

% Read main parameters from the "main" sheet
mainData = readcell(dataFile);
mainData = cell2table(mainData(2:end, 2:end), 'VariableNames', mainData(1, 2:end), 'RowNames', mainData(2:end, 1));

fd.shortName = dataFileName;
fd.fullName = mainData.value{'Full Name'};
fd.spdRatio = mainData.value{'Speed ratio'};
fd.inertia = mainData.value{'Moment of inertia'}; % kg*m^2
fd.mass = mainData.value{'Mass'}; % kg

% Loss evaluation method
lossMethod = mainData.value{'Losses method'};
switch lossMethod
    case "single efficiency"
        fd.lossMethod = "eff";
        fd.eff = mainData.value{'Efficiency'};
    otherwise 
        error("Unsupported losses method """ + lossMethod + """. Supported values are: ""single efficiency"".")
end
    
end